   IPLR           4C        B  A     A  #pragma clang diagnostic ignored "-Wmissing-prototypes"
#pragma clang diagnostic ignored "-Wmissing-braces"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

template<typename T, size_t Num>
struct spvUnsafeArray
{
    T elements[Num ? Num : 1];
    
    thread T& operator [] (size_t pos) thread
    {
        return elements[pos];
    }
    constexpr const thread T& operator [] (size_t pos) const thread
    {
        return elements[pos];
    }
    
    device T& operator [] (size_t pos) device
    {
        return elements[pos];
    }
    constexpr const device T& operator [] (size_t pos) const device
    {
        return elements[pos];
    }
    
    constexpr const constant T& operator [] (size_t pos) const constant
    {
        return elements[pos];
    }
    
    threadgroup T& operator [] (size_t pos) threadgroup
    {
        return elements[pos];
    }
    constexpr const threadgroup T& operator [] (size_t pos) const threadgroup
    {
        return elements[pos];
    }
};

struct liquid_glass_geometry_blended_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct liquid_glass_geometry_blended_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment liquid_glass_geometry_blended_fragment_main_out liquid_glass_geometry_blended_fragment_main(liquid_glass_geometry_blended_fragment_main_in in [[stage_in]], constant float4& uOpticalProps [[buffer(1)]], constant float& uNumShapes [[buffer(2)]], constant spvUnsafeArray<float, 96>& uShapeData [[buffer(3)]])
{
    liquid_glass_geometry_blended_fragment_main_out out = {};
    do
    {
        int _498 = int(uNumShapes);
        float _2031;
        do
        {
            if (_498 == 0)
            {
                _2031 = 1000000000.0;
                break;
            }
            float2 _785 = float2(uShapeData[1], uShapeData[2]);
            float2 _794 = float2(uShapeData[3], uShapeData[4]);
            float _2010;
            do
            {
                if (uShapeData[0] == 1.0)
                {
                    float2 _826 = _794 * float2(0.5);
                    float _867 = fast::min(uShapeData[5], fast::min(_826.x, _826.y));
                    float2 _874 = (abs(in._fragCoord - _785) - _826) + float2(_867);
                    float2 _877 = fast::max(_874, float2(0.0));
                    float _885 = _877.x;
                    float _890 = _877.y;
                    _2010 = (fast::min(fast::max(_874.x, _874.y), 0.0) + sqrt((_885 * _885) + (_890 * _890))) - _867;
                    break;
                }
                if (uShapeData[0] == 2.0)
                {
                    float2 _835 = in._fragCoord - _785;
                    float2 _912 = float2(1.0) / fast::max(_794 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                    float _920 = length(_835 * _912);
                    _2010 = (_920 * (_920 - 1.0)) / fast::max(length(_835 * (_912 * _912)), 9.9999997473787516355514526367188e-05);
                    break;
                }
                if (uShapeData[0] == 3.0)
                {
                    float2 _849 = _794 * float2(0.5);
                    float _944 = fast::min(uShapeData[5], fast::min(_849.x, _849.y));
                    float2 _951 = (abs(in._fragCoord - _785) - _849) + float2(_944);
                    _2010 = (fast::min(fast::max(_951.x, _951.y), 0.0) + length(fast::max(_951, float2(0.0)))) - _944;
                    break;
                }
                _2010 = 1000000000.0;
                break;
            } while(false);
            float _2029;
            if (_498 <= 4)
            {
                float _2023;
                if (_498 >= 2)
                {
                    float2 _990 = float2(uShapeData[7], uShapeData[8]);
                    float2 _999 = float2(uShapeData[9], uShapeData[10]);
                    float _2018;
                    do
                    {
                        if (uShapeData[6] == 1.0)
                        {
                            float2 _1031 = _999 * float2(0.5);
                            float _1072 = fast::min(uShapeData[11], fast::min(_1031.x, _1031.y));
                            float2 _1079 = (abs(in._fragCoord - _990) - _1031) + float2(_1072);
                            float2 _1082 = fast::max(_1079, float2(0.0));
                            float _1090 = _1082.x;
                            float _1095 = _1082.y;
                            _2018 = (fast::min(fast::max(_1079.x, _1079.y), 0.0) + sqrt((_1090 * _1090) + (_1095 * _1095))) - _1072;
                            break;
                        }
                        if (uShapeData[6] == 2.0)
                        {
                            float2 _1040 = in._fragCoord - _990;
                            float2 _1117 = float2(1.0) / fast::max(_999 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1125 = length(_1040 * _1117);
                            _2018 = (_1125 * (_1125 - 1.0)) / fast::max(length(_1040 * (_1117 * _1117)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[6] == 3.0)
                        {
                            float2 _1054 = _999 * float2(0.5);
                            float _1149 = fast::min(uShapeData[11], fast::min(_1054.x, _1054.y));
                            float2 _1156 = (abs(in._fragCoord - _990) - _1054) + float2(_1149);
                            _2018 = (fast::min(fast::max(_1156.x, _1156.y), 0.0) + length(fast::max(_1156, float2(0.0)))) - _1149;
                            break;
                        }
                        _2018 = 1000000000.0;
                        break;
                    } while(false);
                    float _2020;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _2020 = fast::min(_2010, _2018);
                            break;
                        }
                        float _1189 = fast::max(uOpticalProps.w - abs(_2010 - _2018), 0.0);
                        _2020 = fast::min(_2010, _2018) - (((_1189 * _1189) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _2023 = _2020;
                }
                else
                {
                    _2023 = _2010;
                }
                float _2027;
                if (_498 >= 3)
                {
                    float2 _1227 = float2(uShapeData[13], uShapeData[14]);
                    float2 _1236 = float2(uShapeData[15], uShapeData[16]);
                    float _2021;
                    do
                    {
                        if (uShapeData[12] == 1.0)
                        {
                            float2 _1268 = _1236 * float2(0.5);
                            float _1309 = fast::min(uShapeData[17], fast::min(_1268.x, _1268.y));
                            float2 _1316 = (abs(in._fragCoord - _1227) - _1268) + float2(_1309);
                            float2 _1319 = fast::max(_1316, float2(0.0));
                            float _1327 = _1319.x;
                            float _1332 = _1319.y;
                            _2021 = (fast::min(fast::max(_1316.x, _1316.y), 0.0) + sqrt((_1327 * _1327) + (_1332 * _1332))) - _1309;
                            break;
                        }
                        if (uShapeData[12] == 2.0)
                        {
                            float2 _1277 = in._fragCoord - _1227;
                            float2 _1354 = float2(1.0) / fast::max(_1236 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1362 = length(_1277 * _1354);
                            _2021 = (_1362 * (_1362 - 1.0)) / fast::max(length(_1277 * (_1354 * _1354)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[12] == 3.0)
                        {
                            float2 _1291 = _1236 * float2(0.5);
                            float _1386 = fast::min(uShapeData[17], fast::min(_1291.x, _1291.y));
                            float2 _1393 = (abs(in._fragCoord - _1227) - _1291) + float2(_1386);
                            _2021 = (fast::min(fast::max(_1393.x, _1393.y), 0.0) + length(fast::max(_1393, float2(0.0)))) - _1386;
                            break;
                        }
                        _2021 = 1000000000.0;
                        break;
                    } while(false);
                    float _2024;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _2024 = fast::min(_2023, _2021);
                            break;
                        }
                        float _1426 = fast::max(uOpticalProps.w - abs(_2023 - _2021), 0.0);
                        _2024 = fast::min(_2023, _2021) - (((_1426 * _1426) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _2027 = _2024;
                }
                else
                {
                    _2027 = _2023;
                }
                float _2030;
                if (_498 >= 4)
                {
                    float2 _1464 = float2(uShapeData[19], uShapeData[20]);
                    float2 _1473 = float2(uShapeData[21], uShapeData[22]);
                    float _2025;
                    do
                    {
                        if (uShapeData[18] == 1.0)
                        {
                            float2 _1505 = _1473 * float2(0.5);
                            float _1546 = fast::min(uShapeData[23], fast::min(_1505.x, _1505.y));
                            float2 _1553 = (abs(in._fragCoord - _1464) - _1505) + float2(_1546);
                            float2 _1556 = fast::max(_1553, float2(0.0));
                            float _1564 = _1556.x;
                            float _1569 = _1556.y;
                            _2025 = (fast::min(fast::max(_1553.x, _1553.y), 0.0) + sqrt((_1564 * _1564) + (_1569 * _1569))) - _1546;
                            break;
                        }
                        if (uShapeData[18] == 2.0)
                        {
                            float2 _1514 = in._fragCoord - _1464;
                            float2 _1591 = float2(1.0) / fast::max(_1473 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1599 = length(_1514 * _1591);
                            _2025 = (_1599 * (_1599 - 1.0)) / fast::max(length(_1514 * (_1591 * _1591)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[18] == 3.0)
                        {
                            float2 _1528 = _1473 * float2(0.5);
                            float _1623 = fast::min(uShapeData[23], fast::min(_1528.x, _1528.y));
                            float2 _1630 = (abs(in._fragCoord - _1464) - _1528) + float2(_1623);
                            _2025 = (fast::min(fast::max(_1630.x, _1630.y), 0.0) + length(fast::max(_1630, float2(0.0)))) - _1623;
                            break;
                        }
                        _2025 = 1000000000.0;
                        break;
                    } while(false);
                    float _2028;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _2028 = fast::min(_2027, _2025);
                            break;
                        }
                        float _1663 = fast::max(uOpticalProps.w - abs(_2027 - _2025), 0.0);
                        _2028 = fast::min(_2027, _2025) - (((_1663 * _1663) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _2030 = _2028;
                }
                else
                {
                    _2030 = _2027;
                }
                _2029 = _2030;
            }
            else
            {
                float _2014;
                _2014 = _2010;
                float _2015;
                for (int _2011 = 1; _2011 < min(_498, 16); _2014 = _2015, _2011++)
                {
                    int _1689 = _2011 * 6;
                    float2 _1701 = float2(uShapeData[_1689 + 1], uShapeData[_1689 + 2]);
                    float2 _1710 = float2(uShapeData[_1689 + 3], uShapeData[_1689 + 4]);
                    int _1712 = _1689 + 5;
                    float _2012;
                    do
                    {
                        if (uShapeData[_1689] == 1.0)
                        {
                            float2 _1742 = _1710 * float2(0.5);
                            float _1783 = fast::min(uShapeData[_1712], fast::min(_1742.x, _1742.y));
                            float2 _1790 = (abs(in._fragCoord - _1701) - _1742) + float2(_1783);
                            float2 _1793 = fast::max(_1790, float2(0.0));
                            float _1801 = _1793.x;
                            float _1806 = _1793.y;
                            _2012 = (fast::min(fast::max(_1790.x, _1790.y), 0.0) + sqrt((_1801 * _1801) + (_1806 * _1806))) - _1783;
                            break;
                        }
                        if (uShapeData[_1689] == 2.0)
                        {
                            float2 _1751 = in._fragCoord - _1701;
                            float2 _1828 = float2(1.0) / fast::max(_1710 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1836 = length(_1751 * _1828);
                            _2012 = (_1836 * (_1836 - 1.0)) / fast::max(length(_1751 * (_1828 * _1828)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[_1689] == 3.0)
                        {
                            float2 _1765 = _1710 * float2(0.5);
                            float _1860 = fast::min(uShapeData[_1712], fast::min(_1765.x, _1765.y));
                            float2 _1867 = (abs(in._fragCoord - _1701) - _1765) + float2(_1860);
                            _2012 = (fast::min(fast::max(_1867.x, _1867.y), 0.0) + length(fast::max(_1867, float2(0.0)))) - _1860;
                            break;
                        }
                        _2012 = 1000000000.0;
                        break;
                    } while(false);
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _2015 = fast::min(_2014, _2012);
                            break;
                        }
                        float _1900 = fast::max(uOpticalProps.w - abs(_2014 - _2012), 0.0);
                        _2015 = fast::min(_2014, _2012) - (((_1900 * _1900) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                }
                _2029 = _2014;
            }
            _2031 = _2029;
            break;
        } while(false);
        float _513 = 1.0 - smoothstep(-2.0, 0.0, _2031);
        if (_513 < 0.00999999977648258209228515625)
        {
            out.fragColor = float4(0.0);
            break;
        }
        float _525 = dfdx(_2031);
        float _528 = dfdy(_2031);
        float _532 = uOpticalProps.z + _2031;
        float _535 = fast::max(_532, 0.0) / uOpticalProps.z;
        if ((_2031 >= 0.0) || (uOpticalProps.z <= 0.0))
        {
            out.fragColor = float4(0.0);
            break;
        }
        float _585 = mix(sqrt(fast::max(0.0, (uOpticalProps.z * uOpticalProps.z) - (_532 * _532))), uOpticalProps.z, float(_2031 < (-uOpticalProps.z)));
        float3 _600 = refract(float3(0.0, 0.0, -1.0), fast::normalize(float3(_525 * _535, _528 * _535, sqrt(fast::max(0.0, 1.0 - (_535 * _535))))), 1.0 / uOpticalProps.x);
        float _2032;
        if (uOpticalProps.z > 0.0)
        {
            _2032 = fast::clamp(_585 / uOpticalProps.z, 0.0, 1.0);
        }
        else
        {
            _2032 = 0.0;
        }
        out.fragColor = float4(fast::clamp((((_600.xy * ((_585 + (uOpticalProps.z * 8.0)) / fast::max(0.001000000047497451305389404296875, abs(_600.z)))) / float2(uOpticalProps.z * 10.0)) * 0.5) + float2(0.5), float2(0.0), float2(1.0)), _2032, _513);
        break;
    } while(false);
    return out;
}

        t       4           (    0                                `           
   uShapeData     (              $                                
   uNumShapes  (                                    
   uOpticalProps                                             uSize   +   liquid_glass_geometry_blended_fragment_main                          // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform vec4 uOpticalProps;
uniform float uNumShapes;
uniform float uShapeData[96];

vec4 fragColor;

float uThickness;
float uRefractiveIndex;
float uBlend;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

float FLT_flutter_local_sdfSquircle(vec2 p, vec2 b, inout float r)
{
    float shortest = min(b.x, b.y);
    r = min(r, shortest);
    vec2 q = (abs(p) - b) + vec2(r);
    vec2 maxQ = max(q, vec2(0.0));
    return (min(max(q.x, q.y), 0.0) + sqrt((maxQ.x * maxQ.x) + (maxQ.y * maxQ.y))) - r;
}

float FLT_flutter_local_sdfEllipse(vec2 p, inout vec2 r)
{
    r = max(r, vec2(9.9999997473787516355514526367188e-05));
    vec2 invR = vec2(1.0) / r;
    vec2 invR2 = invR * invR;
    vec2 pInvR = p * invR;
    float k1 = length(pInvR);
    vec2 pInvR2 = p * invR2;
    float k2 = length(pInvR2);
    return (k1 * (k1 - 1.0)) / max(k2, 9.9999997473787516355514526367188e-05);
}

float FLT_flutter_local_sdfRRect(vec2 p, vec2 b, inout float r)
{
    float shortest = min(b.x, b.y);
    r = min(r, shortest);
    vec2 q = (abs(p) - b) + vec2(r);
    return (min(max(q.x, q.y), 0.0) + length(max(q, vec2(0.0)))) - r;
}

float FLT_flutter_local_getShapeSDF(float type, vec2 p, vec2 center, vec2 size, float r)
{
    if (type == 1.0)
    {
        vec2 param = p - center;
        vec2 param_1 = size / vec2(2.0);
        float param_2 = r;
        float _256 = FLT_flutter_local_sdfSquircle(param, param_1, param_2);
        return _256;
    }
    if (type == 2.0)
    {
        vec2 param_3 = p - center;
        vec2 param_4 = size / vec2(2.0);
        float _270 = FLT_flutter_local_sdfEllipse(param_3, param_4);
        return _270;
    }
    if (type == 3.0)
    {
        vec2 param_5 = p - center;
        vec2 param_6 = size / vec2(2.0);
        float param_7 = r;
        float _287 = FLT_flutter_local_sdfRRect(param_5, param_6, param_7);
        return _287;
    }
    return 1000000000.0;
}

float FLT_flutter_local_getShapeSDFFromArray(int index, vec2 p, float shapeData[96])
{
    int baseIndex = index * 6;
    float type = shapeData[baseIndex];
    vec2 center = vec2(shapeData[baseIndex + 1], shapeData[baseIndex + 2]);
    vec2 size = vec2(shapeData[baseIndex + 3], shapeData[baseIndex + 4]);
    float cornerRadius = shapeData[baseIndex + 5];
    float param = type;
    vec2 param_1 = p;
    vec2 param_2 = center;
    vec2 param_3 = size;
    float param_4 = cornerRadius;
    return FLT_flutter_local_getShapeSDF(param, param_1, param_2, param_3, param_4);
}

float FLT_flutter_local_smoothUnion(float d1, float d2, float k)
{
    if (k <= 0.0)
    {
        return min(d1, d2);
    }
    float e = max(k - abs(d1 - d2), 0.0);
    return min(d1, d2) - (((e * e) * 0.25) / k);
}

float FLT_flutter_local_sceneSDF(vec2 p, int numShapes, float shapeData[96], float blend)
{
    if (numShapes == 0)
    {
        return 1000000000.0;
    }
    int param = 0;
    vec2 param_1 = p;
    float param_2[96] = shapeData;
    float result = FLT_flutter_local_getShapeSDFFromArray(param, param_1, param_2);
    if (numShapes <= 4)
    {
        if (numShapes >= 2)
        {
            int param_3 = 1;
            vec2 param_4 = p;
            float param_5[96] = shapeData;
            float shapeSDF = FLT_flutter_local_getShapeSDFFromArray(param_3, param_4, param_5);
            float param_6 = result;
            float param_7 = shapeSDF;
            float param_8 = blend;
            result = FLT_flutter_local_smoothUnion(param_6, param_7, param_8);
        }
        if (numShapes >= 3)
        {
            int param_9 = 2;
            vec2 param_10 = p;
            float param_11[96] = shapeData;
            float shapeSDF_1 = FLT_flutter_local_getShapeSDFFromArray(param_9, param_10, param_11);
            float param_12 = result;
            float param_13 = shapeSDF_1;
            float param_14 = blend;
            result = FLT_flutter_local_smoothUnion(param_12, param_13, param_14);
        }
        if (numShapes >= 4)
        {
            int param_15 = 3;
            vec2 param_16 = p;
            float param_17[96] = shapeData;
            float shapeSDF_2 = FLT_flutter_local_getShapeSDFFromArray(param_15, param_16, param_17);
            float param_18 = result;
            float param_19 = shapeSDF_2;
            float param_20 = blend;
            result = FLT_flutter_local_smoothUnion(param_18, param_19, param_20);
        }
    }
    else
    {
        for (int i = 1; i < min(numShapes, 16); i++)
        {
            int param_21 = i;
            vec2 param_22 = p;
            float param_23[96] = shapeData;
            float shapeSDF_3 = FLT_flutter_local_getShapeSDFFromArray(param_21, param_22, param_23);
            float param_24 = result;
            float param_25 = shapeSDF_3;
            float param_26 = blend;
            result = FLT_flutter_local_smoothUnion(param_24, param_25, param_26);
        }
    }
    return result;
}

vec4 FLT_flutter_local_encodeDisplacementData(vec2 displacement, float maxDisplacement, float height, float thickness, float alpha)
{
    vec2 normalizedDisp = ((displacement / vec2(maxDisplacement)) * 0.5) + vec2(0.5);
    normalizedDisp = clamp(normalizedDisp, vec2(0.0), vec2(1.0));
    float _462;
    if (thickness > 0.0)
    {
        _462 = clamp(height / thickness, 0.0, 1.0);
    }
    else
    {
        _462 = 0.0;
    }
    float normalizedHeight = _462;
    return vec4(normalizedDisp.x, normalizedDisp.y, normalizedHeight, alpha);
}

void FLT_main()
{
    uThickness = uOpticalProps.z;
    uRefractiveIndex = uOpticalProps.x;
    uBlend = uOpticalProps.w;
    vec2 fragCoord = FLT_flutter_local_FlutterFragCoord();
    vec2 screenUV = vec2(fragCoord.x / uSize.x, fragCoord.y / uSize.y);
    vec2 param = fragCoord;
    int param_1 = int(uNumShapes);
    float param_2[96] = uShapeData;
    float param_3 = uBlend;
    float sd = FLT_flutter_local_sceneSDF(param, param_1, param_2, param_3);
    float foregroundAlpha = 1.0 - smoothstep(-2.0, 0.0, sd);
    if (foregroundAlpha < 0.00999999977648258209228515625)
    {
        fragColor = vec4(0.0);
        return;
    }
    float dx = dFdx(sd);
    float dy = dFdy(sd);
    float n_cos = max(uThickness + sd, 0.0) / uThickness;
    float n_sin = sqrt(max(0.0, 1.0 - (n_cos * n_cos)));
    vec3 normal = normalize(vec3(dx * n_cos, dy * n_cos, n_sin));
    if ((sd >= 0.0) || (uThickness <= 0.0))
    {
        fragColor = vec4(0.0);
        return;
    }
    float x = uThickness + sd;
    float sqrtTerm = sqrt(max(0.0, (uThickness * uThickness) - (x * x)));
    float height_1 = mix(sqrtTerm, uThickness, float(sd < (-uThickness)));
    float baseHeight = uThickness * 8.0;
    vec3 incident = vec3(0.0, 0.0, -1.0);
    float invRefractiveIndex = 1.0 / uRefractiveIndex;
    vec3 baseRefract = refract(incident, normal, invRefractiveIndex);
    float baseRefractLength = (height_1 + baseHeight) / max(0.001000000047497451305389404296875, abs(baseRefract.z));
    vec2 displacement_1 = baseRefract.xy * baseRefractLength;
    float maxDisplacement_1 = uThickness * 10.0;
    vec2 param_4 = displacement_1;
    float param_5 = maxDisplacement_1;
    float param_6 = height_1;
    float param_7 = uThickness;
    float param_8 = foregroundAlpha;
    fragColor = FLT_flutter_local_encodeDisplacementData(param_4, param_5, param_6, param_7, param_8);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
           \       0           (    ,                                `       
   uShapeData  (                                    
   uNumShapes     ,              (                                    
   uOpticalProps  $                                               uSize   +   liquid_glass_geometry_blended_fragment_main 