   IPLR            .     <     /  #include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

constant float _594 = {};
constant float4 _595 = {};

struct liquid_glass_final_render_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct liquid_glass_final_render_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment liquid_glass_final_render_fragment_main_out liquid_glass_final_render_fragment_main(liquid_glass_final_render_fragment_main_in in [[stage_in]], constant float2& uSize [[buffer(0)]], constant float2& uGeometryOffset [[buffer(1)]], constant float2& uGeometrySize [[buffer(2)]], constant float4& uGlassColor [[buffer(3)]], constant float3& uOpticalProps [[buffer(4)]], constant float3& uLightConfig [[buffer(5)]], constant float2& uLightDirection [[buffer(6)]], texture2d<float> uBackgroundTexture [[texture(0)]], texture2d<float> uGeometryTexture [[texture(1)]], sampler uBackgroundTextureSmplr [[sampler(0)]], sampler uGeometryTextureSmplr [[sampler(1)]])
{
    liquid_glass_final_render_fragment_main_out out = {};
    do
    {
        float2 _191 = float2(in._fragCoord.x / uSize.x, in._fragCoord.y / uSize.y);
        float4 _207 = uGeometryTexture.sample(uGeometryTextureSmplr, ((in._fragCoord - uGeometryOffset) / uGeometrySize));
        float _209 = _207.w;
        if (_209 < 0.00999999977648258209228515625)
        {
            out.fragColor = float4(0.0);
            break;
        }
        float2 _461 = ((_207.xy - float2(0.5)) * 2.0) * (uOpticalProps.z * 10.0);
        float2 _231 = float2(1.0) / uSize;
        float4 _584;
        if (uOpticalProps.y < 0.00999999977648258209228515625)
        {
            _584 = uBackgroundTexture.sample(uBackgroundTextureSmplr, (_191 + (_461 * _231)));
        }
        else
        {
            float _250 = uOpticalProps.y * 0.5;
            _584 = float4(uBackgroundTexture.sample(uBackgroundTextureSmplr, (_191 + ((_461 * (1.0 + _250)) * _231))).x, uBackgroundTexture.sample(uBackgroundTextureSmplr, (_191 + (_461 * _231))).y, uBackgroundTexture.sample(uBackgroundTextureSmplr, (_191 + ((_461 * (1.0 - _250)) * _231))).z, _594);
        }
        float4 _586;
        if (uGlassColor.w > 0.0)
        {
            float4 _585;
            if (dot(uGlassColor.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625)) < 0.5)
            {
                float3 _494 = mix(_584.xyz, _584.xyz * (uGlassColor.xyz * 2.0), float3(uGlassColor.w));
                float4 _555;
                _555.x = _494.x;
                _555.y = _494.y;
                _555.z = _494.z;
                _585 = _555;
            }
            else
            {
                float3 _518 = mix(_584.xyz, float3(1.0) - ((float3(1.0) - _584.xyz) * (float3(1.0) - uGlassColor.xyz)), float3(uGlassColor.w));
                float4 _562;
                _562.x = _518.x;
                _562.y = _518.y;
                _562.z = _518.z;
                _585 = _562;
            }
            _586 = _585;
        }
        else
        {
            _586 = _584;
        }
        float3 _546 = fast::clamp(mix(float3(dot(_586.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625))), _586.xyz, float3(uLightConfig.z)), float3(0.0), float3(1.0));
        float4 _571;
        _571.x = _546.x;
        _571.y = _546.y;
        _571.z = _546.z;
        float _329 = fast::clamp(40.0 / fast::max(uOpticalProps.z, 1.0), 1.0, 4.0);
        float _339 = 1.0 - smoothstep(0.0, mix(0.800000011920928955078125, 0.5, 1.0 / _329), _207.z);
        float4 _589;
        if (_339 > 0.00999999977648258209228515625)
        {
            float2 _346 = fast::normalize(_461);
            float _389 = dot(_584.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
            float3 _422 = mix(_571.xyz, mix(float3(1.0), mix(_584.xyz, _584.xyz / float3(fast::max(_389, 0.001000000047497451305389404296875)), float3(0.800000011920928955078125)), float3(fast::clamp(length(_584.xyz - float3(_389)) + 0.5, 0.5, 1.0))), float3((((((powr(fast::max(0.0, dot(_346, uLightDirection)) + (fast::max(0.0, dot(_346, -uLightDirection)) * 0.800000011920928955078125), 1.5) * uLightConfig.x) * 3.0) + (uLightConfig.y * 0.5)) * _339) * _329) * 0.800000011920928955078125));
            float4 _578;
            _578.x = _422.x;
            _578.y = _422.y;
            _578.z = _422.z;
            _589 = _578;
        }
        else
        {
            _589 = _571;
        }
        out.fragColor = float4(_589.xyz * _209, _209);
        break;
    } while(false);
    return out;
}

 	   (      T          H      $                                  uGeometryTexture                                   uBackgroundTexture  z(                                       uLightDirection (                                       uLightConfig    (                                    
   uOpticalProps   $                                   uGlassColor r(                                    
   uGeometrySize   b$                                   uGeometryOffset    $                                               uSize   '   liquid_glass_final_render_fragment_main                 h         // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform vec2 uGeometryOffset;
uniform vec2 uGeometrySize;
uniform vec4 uGlassColor;
uniform vec3 uOpticalProps;
uniform vec3 uLightConfig;
uniform vec2 uLightDirection;
uniform shader uBackgroundTexture;
uniform half2 uBackgroundTexture_size;
uniform shader uGeometryTexture;
uniform half2 uGeometryTexture_size;

vec4 fragColor;

float uRefractiveIndex;
float uChromaticAberration;
float uThickness;
float uLightIntensity;
float uAmbientStrength;
float uSaturation;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

vec2 FLT_flutter_local_decodeDisplacement(vec4 encoded, float maxDisplacement)
{
    vec2 normalized = encoded.xy;
    vec2 displacement = ((normalized - vec2(0.5)) * 2.0) * maxDisplacement;
    return displacement;
}

vec4 FLT_flutter_local_applyGlassColor(vec4 liquidColor, vec4 glassColor)
{
    vec4 finalColor = liquidColor;
    if (glassColor.w > 0.0)
    {
        float glassLuminance = dot(glassColor.xyz, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
        if (glassLuminance < 0.5)
        {
            vec3 darkened = liquidColor.xyz * (glassColor.xyz * 2.0);
            vec3 _136 = mix(liquidColor.xyz, darkened, vec3(glassColor.w));
            finalColor.x = _136.x;
            finalColor.y = _136.y;
            finalColor.z = _136.z;
        }
        else
        {
            vec3 invLiquid = vec3(1.0) - liquidColor.xyz;
            vec3 invGlass = vec3(1.0) - glassColor.xyz;
            vec3 screened = vec3(1.0) - (invLiquid * invGlass);
            vec3 _164 = mix(liquidColor.xyz, screened, vec3(glassColor.w));
            finalColor.x = _164.x;
            finalColor.y = _164.y;
            finalColor.z = _164.z;
        }
        finalColor.w = liquidColor.w;
    }
    return finalColor;
}

vec3 FLT_flutter_local_applySaturation(vec3 color, float saturation)
{
    float luminance = dot(color, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
    vec3 saturatedColor = mix(vec3(luminance), color, vec3(saturation));
    return clamp(saturatedColor, vec3(0.0), vec3(1.0));
}

void FLT_main()
{
    uRefractiveIndex = uOpticalProps.x;
    uChromaticAberration = uOpticalProps.y;
    uThickness = uOpticalProps.z;
    uLightIntensity = uLightConfig.x;
    uAmbientStrength = uLightConfig.y;
    uSaturation = uLightConfig.z;
    vec2 fragCoord = FLT_flutter_local_FlutterFragCoord();
    vec2 screenUV = vec2(fragCoord.x / uSize.x, fragCoord.y / uSize.y);
    vec2 geometryUV = (fragCoord - uGeometryOffset) / uGeometrySize;
    vec4 geometryData = uGeometryTexture.eval(uGeometryTexture_size * ( geometryUV));
    if (geometryData.w < 0.00999999977648258209228515625)
    {
        fragColor = vec4(0.0);
        return;
    }
    float maxDisplacement = uThickness * 10.0;
    vec4 param = geometryData;
    float param_1 = maxDisplacement;
    vec2 displacement = FLT_flutter_local_decodeDisplacement(param, param_1);
    vec2 invUSize = vec2(1.0) / uSize;
    vec4 refractColor;
    if (uChromaticAberration < 0.00999999977648258209228515625)
    {
        vec2 refractedUV = screenUV + (displacement * invUSize);
        refractColor = uBackgroundTexture.eval(uBackgroundTexture_size * ( refractedUV));
    }
    else
    {
        float dispersionStrength = uChromaticAberration * 0.5;
        vec2 redOffset = displacement * (1.0 + dispersionStrength);
        vec2 blueOffset = displacement * (1.0 - dispersionStrength);
        vec2 redUV = screenUV + (redOffset * invUSize);
        vec2 greenUV = screenUV + (displacement * invUSize);
        vec2 blueUV = screenUV + (blueOffset * invUSize);
        float red = uBackgroundTexture.eval(uBackgroundTexture_size * ( redUV)).x;
        vec4 greenSample = uBackgroundTexture.eval(uBackgroundTexture_size * ( greenUV));
        float blue = uBackgroundTexture.eval(uBackgroundTexture_size * ( blueUV)).z;
        refractColor = vec4(red, greenSample.y, blue, greenSample.w);
    }
    vec4 param_2 = refractColor;
    vec4 param_3 = uGlassColor;
    vec4 finalColor = FLT_flutter_local_applyGlassColor(param_2, param_3);
    vec3 param_4 = finalColor.xyz;
    float param_5 = uSaturation;
    vec3 _314 = FLT_flutter_local_applySaturation(param_4, param_5);
    finalColor.x = _314.x;
    finalColor.y = _314.y;
    finalColor.z = _314.z;
    float normalizedHeight = geometryData.z;
    float thicknessScale = clamp(40.0 / max(uThickness, 1.0), 1.0, 4.0);
    float edgeThreshold = mix(0.800000011920928955078125, 0.5, 1.0 / thicknessScale);
    float edgeFactor = 1.0 - smoothstep(0.0, edgeThreshold, normalizedHeight);
    if (edgeFactor > 0.00999999977648258209228515625)
    {
        vec2 normalXY = normalize(displacement);
        float mainLight = max(0.0, dot(normalXY, uLightDirection));
        float oppositeLight = max(0.0, dot(normalXY, -uLightDirection));
        float totalInfluence = mainLight + (oppositeLight * 0.800000011920928955078125);
        float directional = (pow(totalInfluence, 1.5) * uLightIntensity) * 3.0;
        float ambient = uAmbientStrength * 0.5;
        float brightness = (((directional + ambient) * edgeFactor) * thicknessScale) * 0.800000011920928955078125;
        vec3 bgColor = refractColor.xyz;
        float bgLuminance = dot(bgColor, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
        vec3 saturatedBg = bgColor / vec3(max(bgLuminance, 0.001000000047497451305389404296875));
        saturatedBg = mix(bgColor, saturatedBg, vec3(0.800000011920928955078125));
        float colorfulness = length(bgColor - vec3(bgLuminance));
        float colorMix = clamp((colorfulness * 1.0) + 0.5, 0.5, 1.0);
        vec3 highlightColor = mix(vec3(1.0), saturatedBg, vec3(colorMix));
        vec4 _418 = finalColor;
        vec3 _423 = mix(_418.xyz, highlightColor, vec3(brightness));
        finalColor.x = _423.x;
        finalColor.y = _423.y;
        finalColor.z = _423.z;
    }
    float alpha = geometryData.w;
    fragColor = vec4(finalColor.xyz * alpha, alpha);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
	   t       x  4        l         (             $                                  uGeometryTexture   $                                            uBackgroundTexture  (                                       uLightDirection B(                                       uLightConfig    (                                    
   uOpticalProps   (                                       uGlassColor    ,              (                                    
   uGeometrySize  (              $                                   uGeometryOffset                                               uSize   '   liquid_glass_final_render_fragment_main 