   IPLR           4X        W  U     U  #pragma clang diagnostic ignored "-Wmissing-prototypes"
#pragma clang diagnostic ignored "-Wmissing-braces"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

template<typename T, size_t Num>
struct spvUnsafeArray
{
    T elements[Num ? Num : 1];
    
    thread T& operator [] (size_t pos) thread
    {
        return elements[pos];
    }
    constexpr const thread T& operator [] (size_t pos) const thread
    {
        return elements[pos];
    }
    
    device T& operator [] (size_t pos) device
    {
        return elements[pos];
    }
    constexpr const device T& operator [] (size_t pos) const device
    {
        return elements[pos];
    }
    
    constexpr const constant T& operator [] (size_t pos) const constant
    {
        return elements[pos];
    }
    
    threadgroup T& operator [] (size_t pos) threadgroup
    {
        return elements[pos];
    }
    constexpr const threadgroup T& operator [] (size_t pos) const threadgroup
    {
        return elements[pos];
    }
};

struct liquid_glass_filter_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct liquid_glass_filter_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment liquid_glass_filter_fragment_main_out liquid_glass_filter_fragment_main(liquid_glass_filter_fragment_main_in in [[stage_in]], constant float2& uSize [[buffer(0)]], constant float4& uGlassColor [[buffer(1)]], constant float4& uOpticalProps [[buffer(2)]], constant float4& uLightConfig [[buffer(3)]], constant float2& uLightDirection [[buffer(4)]], constant float& uNumShapes [[buffer(5)]], constant spvUnsafeArray<float, 96>& uShapeData [[buffer(6)]], texture2d<float> uBlurredTexture [[texture(0)]], sampler uBlurredTextureSmplr [[sampler(0)]])
{
    liquid_glass_filter_fragment_main_out out = {};
    do
    {
        float2 _1079 = float2(in._fragCoord.x / uSize.x, in._fragCoord.y / uSize.y);
        int _1083 = int(uNumShapes);
        float _3088;
        do
        {
            if (_1083 == 0)
            {
                _3088 = 1000000000.0;
                break;
            }
            float2 _1314 = float2(uShapeData[1], uShapeData[2]);
            float2 _1323 = float2(uShapeData[3], uShapeData[4]);
            float _3067;
            do
            {
                if (uShapeData[0] == 1.0)
                {
                    float2 _1355 = _1323 * float2(0.5);
                    float _1396 = fast::min(uShapeData[5], fast::min(_1355.x, _1355.y));
                    float2 _1403 = (abs(in._fragCoord - _1314) - _1355) + float2(_1396);
                    float2 _1406 = fast::max(_1403, float2(0.0));
                    float _1414 = _1406.x;
                    float _1419 = _1406.y;
                    _3067 = (fast::min(fast::max(_1403.x, _1403.y), 0.0) + sqrt((_1414 * _1414) + (_1419 * _1419))) - _1396;
                    break;
                }
                if (uShapeData[0] == 2.0)
                {
                    float2 _1364 = in._fragCoord - _1314;
                    float2 _1441 = float2(1.0) / fast::max(_1323 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                    float _1449 = length(_1364 * _1441);
                    _3067 = (_1449 * (_1449 - 1.0)) / fast::max(length(_1364 * (_1441 * _1441)), 9.9999997473787516355514526367188e-05);
                    break;
                }
                if (uShapeData[0] == 3.0)
                {
                    float2 _1378 = _1323 * float2(0.5);
                    float _1473 = fast::min(uShapeData[5], fast::min(_1378.x, _1378.y));
                    float2 _1480 = (abs(in._fragCoord - _1314) - _1378) + float2(_1473);
                    _3067 = (fast::min(fast::max(_1480.x, _1480.y), 0.0) + length(fast::max(_1480, float2(0.0)))) - _1473;
                    break;
                }
                _3067 = 1000000000.0;
                break;
            } while(false);
            float _3086;
            if (_1083 <= 4)
            {
                float _3080;
                if (_1083 >= 2)
                {
                    float2 _1519 = float2(uShapeData[7], uShapeData[8]);
                    float2 _1528 = float2(uShapeData[9], uShapeData[10]);
                    float _3075;
                    do
                    {
                        if (uShapeData[6] == 1.0)
                        {
                            float2 _1560 = _1528 * float2(0.5);
                            float _1601 = fast::min(uShapeData[11], fast::min(_1560.x, _1560.y));
                            float2 _1608 = (abs(in._fragCoord - _1519) - _1560) + float2(_1601);
                            float2 _1611 = fast::max(_1608, float2(0.0));
                            float _1619 = _1611.x;
                            float _1624 = _1611.y;
                            _3075 = (fast::min(fast::max(_1608.x, _1608.y), 0.0) + sqrt((_1619 * _1619) + (_1624 * _1624))) - _1601;
                            break;
                        }
                        if (uShapeData[6] == 2.0)
                        {
                            float2 _1569 = in._fragCoord - _1519;
                            float2 _1646 = float2(1.0) / fast::max(_1528 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1654 = length(_1569 * _1646);
                            _3075 = (_1654 * (_1654 - 1.0)) / fast::max(length(_1569 * (_1646 * _1646)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[6] == 3.0)
                        {
                            float2 _1583 = _1528 * float2(0.5);
                            float _1678 = fast::min(uShapeData[11], fast::min(_1583.x, _1583.y));
                            float2 _1685 = (abs(in._fragCoord - _1519) - _1583) + float2(_1678);
                            _3075 = (fast::min(fast::max(_1685.x, _1685.y), 0.0) + length(fast::max(_1685, float2(0.0)))) - _1678;
                            break;
                        }
                        _3075 = 1000000000.0;
                        break;
                    } while(false);
                    float _3077;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _3077 = fast::min(_3067, _3075);
                            break;
                        }
                        float _1718 = fast::max(uOpticalProps.w - abs(_3067 - _3075), 0.0);
                        _3077 = fast::min(_3067, _3075) - (((_1718 * _1718) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _3080 = _3077;
                }
                else
                {
                    _3080 = _3067;
                }
                float _3084;
                if (_1083 >= 3)
                {
                    float2 _1756 = float2(uShapeData[13], uShapeData[14]);
                    float2 _1765 = float2(uShapeData[15], uShapeData[16]);
                    float _3078;
                    do
                    {
                        if (uShapeData[12] == 1.0)
                        {
                            float2 _1797 = _1765 * float2(0.5);
                            float _1838 = fast::min(uShapeData[17], fast::min(_1797.x, _1797.y));
                            float2 _1845 = (abs(in._fragCoord - _1756) - _1797) + float2(_1838);
                            float2 _1848 = fast::max(_1845, float2(0.0));
                            float _1856 = _1848.x;
                            float _1861 = _1848.y;
                            _3078 = (fast::min(fast::max(_1845.x, _1845.y), 0.0) + sqrt((_1856 * _1856) + (_1861 * _1861))) - _1838;
                            break;
                        }
                        if (uShapeData[12] == 2.0)
                        {
                            float2 _1806 = in._fragCoord - _1756;
                            float2 _1883 = float2(1.0) / fast::max(_1765 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _1891 = length(_1806 * _1883);
                            _3078 = (_1891 * (_1891 - 1.0)) / fast::max(length(_1806 * (_1883 * _1883)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[12] == 3.0)
                        {
                            float2 _1820 = _1765 * float2(0.5);
                            float _1915 = fast::min(uShapeData[17], fast::min(_1820.x, _1820.y));
                            float2 _1922 = (abs(in._fragCoord - _1756) - _1820) + float2(_1915);
                            _3078 = (fast::min(fast::max(_1922.x, _1922.y), 0.0) + length(fast::max(_1922, float2(0.0)))) - _1915;
                            break;
                        }
                        _3078 = 1000000000.0;
                        break;
                    } while(false);
                    float _3081;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _3081 = fast::min(_3080, _3078);
                            break;
                        }
                        float _1955 = fast::max(uOpticalProps.w - abs(_3080 - _3078), 0.0);
                        _3081 = fast::min(_3080, _3078) - (((_1955 * _1955) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _3084 = _3081;
                }
                else
                {
                    _3084 = _3080;
                }
                float _3087;
                if (_1083 >= 4)
                {
                    float2 _1993 = float2(uShapeData[19], uShapeData[20]);
                    float2 _2002 = float2(uShapeData[21], uShapeData[22]);
                    float _3082;
                    do
                    {
                        if (uShapeData[18] == 1.0)
                        {
                            float2 _2034 = _2002 * float2(0.5);
                            float _2075 = fast::min(uShapeData[23], fast::min(_2034.x, _2034.y));
                            float2 _2082 = (abs(in._fragCoord - _1993) - _2034) + float2(_2075);
                            float2 _2085 = fast::max(_2082, float2(0.0));
                            float _2093 = _2085.x;
                            float _2098 = _2085.y;
                            _3082 = (fast::min(fast::max(_2082.x, _2082.y), 0.0) + sqrt((_2093 * _2093) + (_2098 * _2098))) - _2075;
                            break;
                        }
                        if (uShapeData[18] == 2.0)
                        {
                            float2 _2043 = in._fragCoord - _1993;
                            float2 _2120 = float2(1.0) / fast::max(_2002 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _2128 = length(_2043 * _2120);
                            _3082 = (_2128 * (_2128 - 1.0)) / fast::max(length(_2043 * (_2120 * _2120)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[18] == 3.0)
                        {
                            float2 _2057 = _2002 * float2(0.5);
                            float _2152 = fast::min(uShapeData[23], fast::min(_2057.x, _2057.y));
                            float2 _2159 = (abs(in._fragCoord - _1993) - _2057) + float2(_2152);
                            _3082 = (fast::min(fast::max(_2159.x, _2159.y), 0.0) + length(fast::max(_2159, float2(0.0)))) - _2152;
                            break;
                        }
                        _3082 = 1000000000.0;
                        break;
                    } while(false);
                    float _3085;
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _3085 = fast::min(_3084, _3082);
                            break;
                        }
                        float _2192 = fast::max(uOpticalProps.w - abs(_3084 - _3082), 0.0);
                        _3085 = fast::min(_3084, _3082) - (((_2192 * _2192) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                    _3087 = _3085;
                }
                else
                {
                    _3087 = _3084;
                }
                _3086 = _3087;
            }
            else
            {
                float _3071;
                _3071 = _3067;
                float _3072;
                for (int _3068 = 1; _3068 < min(_1083, 16); _3071 = _3072, _3068++)
                {
                    int _2218 = _3068 * 6;
                    float2 _2230 = float2(uShapeData[_2218 + 1], uShapeData[_2218 + 2]);
                    float2 _2239 = float2(uShapeData[_2218 + 3], uShapeData[_2218 + 4]);
                    int _2241 = _2218 + 5;
                    float _3069;
                    do
                    {
                        if (uShapeData[_2218] == 1.0)
                        {
                            float2 _2271 = _2239 * float2(0.5);
                            float _2312 = fast::min(uShapeData[_2241], fast::min(_2271.x, _2271.y));
                            float2 _2319 = (abs(in._fragCoord - _2230) - _2271) + float2(_2312);
                            float2 _2322 = fast::max(_2319, float2(0.0));
                            float _2330 = _2322.x;
                            float _2335 = _2322.y;
                            _3069 = (fast::min(fast::max(_2319.x, _2319.y), 0.0) + sqrt((_2330 * _2330) + (_2335 * _2335))) - _2312;
                            break;
                        }
                        if (uShapeData[_2218] == 2.0)
                        {
                            float2 _2280 = in._fragCoord - _2230;
                            float2 _2357 = float2(1.0) / fast::max(_2239 * float2(0.5), float2(9.9999997473787516355514526367188e-05));
                            float _2365 = length(_2280 * _2357);
                            _3069 = (_2365 * (_2365 - 1.0)) / fast::max(length(_2280 * (_2357 * _2357)), 9.9999997473787516355514526367188e-05);
                            break;
                        }
                        if (uShapeData[_2218] == 3.0)
                        {
                            float2 _2294 = _2239 * float2(0.5);
                            float _2389 = fast::min(uShapeData[_2241], fast::min(_2294.x, _2294.y));
                            float2 _2396 = (abs(in._fragCoord - _2230) - _2294) + float2(_2389);
                            _3069 = (fast::min(fast::max(_2396.x, _2396.y), 0.0) + length(fast::max(_2396, float2(0.0)))) - _2389;
                            break;
                        }
                        _3069 = 1000000000.0;
                        break;
                    } while(false);
                    do
                    {
                        if (uOpticalProps.w <= 0.0)
                        {
                            _3072 = fast::min(_3071, _3069);
                            break;
                        }
                        float _2429 = fast::max(uOpticalProps.w - abs(_3071 - _3069), 0.0);
                        _3072 = fast::min(_3071, _3069) - (((_2429 * _2429) * 0.25) / uOpticalProps.w);
                        break;
                    } while(false);
                }
                _3086 = _3071;
            }
            _3088 = _3086;
            break;
        } while(false);
        float _1098 = 1.0 - smoothstep(-2.0, 0.0, _3088);
        if (_1098 < 0.00999999977648258209228515625)
        {
            out.fragColor = float4(0.0);
            break;
        }
        float _2449 = dfdx(_3088);
        float _2451 = dfdy(_3088);
        float _2454 = uOpticalProps.z + _3088;
        float _2457 = fast::max(_2454, 0.0) / uOpticalProps.z;
        float3 _2472 = fast::normalize(float3(_2449 * _2457, _2451 * _2457, sqrt(fast::max(0.0, 1.0 - (_2457 * _2457)))));
        float _3089;
        do
        {
            if ((_3088 >= 0.0) || (uOpticalProps.z <= 0.0))
            {
                _3089 = 0.0;
                break;
            }
            if (_3088 < (-uOpticalProps.z))
            {
                _3089 = uOpticalProps.z;
                break;
            }
            _3089 = sqrt(fast::max(0.0, (uOpticalProps.z * uOpticalProps.z) - (_2454 * _2454)));
            break;
        } while(false);
        float4 _3090;
        do
        {
            float2 _2619 = float2(1.0) / uSize;
            float3 _2623 = refract(float3(0.0, 0.0, -1.0), _2472, 1.0 / uOpticalProps.x);
            float2 _2635 = _2623.xy * ((_3089 + (uOpticalProps.z * 8.0)) / fast::max(0.001000000047497451305389404296875, abs(_2623.z)));
            if (uOpticalProps.y < 0.001000000047497451305389404296875)
            {
                _3090 = uBlurredTexture.sample(uBlurredTextureSmplr, (_1079 + (_2635 * _2619)));
                break;
            }
            float _2650 = uOpticalProps.y * 0.5;
            float4 _2680 = uBlurredTexture.sample(uBlurredTextureSmplr, (_1079 + (_2635 * _2619)));
            _3090 = float4(uBlurredTexture.sample(uBlurredTextureSmplr, (_1079 + ((_2635 * (1.0 + _2650)) * _2619))).x, _2680.y, uBlurredTexture.sample(uBlurredTextureSmplr, (_1079 + ((_2635 * (1.0 - _2650)) * _2619))).z, _2680.w);
            break;
        } while(false);
        float3 _3094;
        do
        {
            float _3091;
            if (uOpticalProps.z > 0.0)
            {
                _3091 = _3089 / uOpticalProps.z;
            }
            else
            {
                _3091 = 0.0;
            }
            float _2729 = fast::clamp((1.0 - _3091) * 1.11099994182586669921875, 0.0, 1.0);
            if (_2729 < 0.00999999977648258209228515625)
            {
                _3094 = float3(0.0);
                break;
            }
            float _2737 = fast::clamp((uOpticalProps.z - 5.0) * 0.5, 0.0, 1.0);
            if (_2737 < 0.00999999977648258209228515625)
            {
                _3094 = float3(0.0);
                break;
            }
            float _2751 = 1.0 / (1.0 + ((_3088 * 0.59333336353302001953125) * (_3088 * 0.666666686534881591796875)));
            if ((_2751 < 0.00999999977648258209228515625) || (uLightConfig.y < 0.00999999977648258209228515625))
            {
                _3094 = float3(0.0);
                break;
            }
            float2 _2760 = _2472.xy;
            float _2773 = fast::max(0.0, dot(_2760, uLightDirection)) + (fast::max(0.0, dot(_2760, -uLightDirection)) * 0.800000011920928955078125);
            float _2817 = dot(_3090.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
            float _2825 = fast::max(fast::max(_3090.x, _3090.y), _3090.z);
            float _3092;
            if (_2825 > 0.0)
            {
                _3092 = (_2825 - fast::min(fast::min(_3090.x, _3090.y), _3090.z)) / _2825;
            }
            else
            {
                _3092 = 0.0;
            }
            float3 _3093;
            if (_2817 > 0.001000000047497451305389404296875)
            {
                float3 _2856 = (_3090.xyz / float3(_2817)) * 1.0;
                _3093 = fast::min(mix(float3(dot(_2856, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625))), _2856, float3(1.2999999523162841796875)), float3(1.0));
            }
            else
            {
                _3093 = float3(1.0);
            }
            float3 _2881 = mix(float3(1.0), _3093, float3(smoothstep(0.0, 0.60000002384185791015625, _2817) * smoothstep(0.0, 0.4000000059604644775390625, _3092)));
            _3094 = (((((((_2881 * 0.699999988079071044921875) * (_2773 * _2773)) * uLightConfig.y) * 2.0) + ((_2881 * 0.4000000059604644775390625) * uLightConfig.z)) * _2751) * _2737) * _2729;
            break;
        } while(false);
        float4 _3096;
        if (uGlassColor.w > 0.0)
        {
            float4 _3095;
            if (dot(uGlassColor.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625)) < 0.5)
            {
                float3 _2913 = mix(_3090.xyz, _3090.xyz * (uGlassColor.xyz * 2.0), float3(uGlassColor.w));
                float4 _3040 = _3090;
                _3040.x = _2913.x;
                _3040.y = _2913.y;
                _3040.z = _2913.z;
                _3095 = _3040;
            }
            else
            {
                float3 _2937 = mix(_3090.xyz, float3(1.0) - ((float3(1.0) - _3090.xyz) * (float3(1.0) - uGlassColor.xyz)), float3(uGlassColor.w));
                float4 _3047 = _3090;
                _3047.x = _2937.x;
                _3047.y = _2937.y;
                _3047.z = _2937.z;
                _3095 = _3047;
            }
            float4 _3054 = _3095;
            _3054.w = _3090.w;
            _3096 = _3054;
        }
        else
        {
            _3096 = _3090;
        }
        float3 _2536 = _3096.xyz + _3094;
        float4 _3056 = _3096;
        _3056.x = _2536.x;
        _3056.y = _2536.y;
        _3056.z = _2536.z;
        float3 _2965 = fast::clamp(mix(float3(dot(_3056.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625))), _3056.xyz, float3(uLightConfig.w)), float3(0.0), float3(1.0));
        float4 _3062 = _3056;
        _3062.x = _2965.x;
        _3062.y = _2965.y;
        _3062.z = _2965.z;
        out.fragColor = mix(float4(0.0), _3062, float4(_1098));
        break;
    } while(false);
    return out;
}

          P          H      ,                                `       
   uShapeData  ҽ$                                
   uNumShapes  Z(                                       uLightDirection (                                       uLightConfig    ھ(                                    
   uOpticalProps   ʾ$                                   uGlassColor                                              uBlurredTexture                                  uSize   !   liquid_glass_filter_fragment_main               A  >     >  // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform vec4 uGlassColor;
uniform vec4 uOpticalProps;
uniform vec4 uLightConfig;
uniform vec2 uLightDirection;
uniform float uNumShapes;
uniform float uShapeData[96];
uniform shader uBlurredTexture;
uniform half2 uBlurredTexture_size;

vec4 fragColor;

float uChromaticAberration;
float uLightAngle;
float uLightIntensity;
float uAmbientStrength;
float uThickness;
float uRefractiveIndex;
float uBlend;
float uSaturation;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

float FLT_flutter_local_sdfSquircle(vec2 p, vec2 b, inout float r)
{
    float shortest = min(b.x, b.y);
    r = min(r, shortest);
    vec2 q = (abs(p) - b) + vec2(r);
    vec2 maxQ = max(q, vec2(0.0));
    return (min(max(q.x, q.y), 0.0) + sqrt((maxQ.x * maxQ.x) + (maxQ.y * maxQ.y))) - r;
}

float FLT_flutter_local_sdfEllipse(vec2 p, inout vec2 r)
{
    r = max(r, vec2(9.9999997473787516355514526367188e-05));
    vec2 invR = vec2(1.0) / r;
    vec2 invR2 = invR * invR;
    vec2 pInvR = p * invR;
    float k1 = length(pInvR);
    vec2 pInvR2 = p * invR2;
    float k2 = length(pInvR2);
    return (k1 * (k1 - 1.0)) / max(k2, 9.9999997473787516355514526367188e-05);
}

float FLT_flutter_local_sdfRRect(vec2 p, vec2 b, inout float r)
{
    float shortest = min(b.x, b.y);
    r = min(r, shortest);
    vec2 q = (abs(p) - b) + vec2(r);
    return (min(max(q.x, q.y), 0.0) + length(max(q, vec2(0.0)))) - r;
}

float FLT_flutter_local_getShapeSDF(float type, vec2 p, vec2 center, vec2 size, float r)
{
    if (type == 1.0)
    {
        vec2 param = p - center;
        vec2 param_1 = size / vec2(2.0);
        float param_2 = r;
        float _844 = FLT_flutter_local_sdfSquircle(param, param_1, param_2);
        return _844;
    }
    if (type == 2.0)
    {
        vec2 param_3 = p - center;
        vec2 param_4 = size / vec2(2.0);
        float _858 = FLT_flutter_local_sdfEllipse(param_3, param_4);
        return _858;
    }
    if (type == 3.0)
    {
        vec2 param_5 = p - center;
        vec2 param_6 = size / vec2(2.0);
        float param_7 = r;
        float _875 = FLT_flutter_local_sdfRRect(param_5, param_6, param_7);
        return _875;
    }
    return 1000000000.0;
}

float FLT_flutter_local_getShapeSDFFromArray(int index, vec2 p, float shapeData[96])
{
    int baseIndex = index * 6;
    float type = shapeData[baseIndex];
    vec2 center = vec2(shapeData[baseIndex + 1], shapeData[baseIndex + 2]);
    vec2 size = vec2(shapeData[baseIndex + 3], shapeData[baseIndex + 4]);
    float cornerRadius = shapeData[baseIndex + 5];
    float param = type;
    vec2 param_1 = p;
    vec2 param_2 = center;
    vec2 param_3 = size;
    float param_4 = cornerRadius;
    return FLT_flutter_local_getShapeSDF(param, param_1, param_2, param_3, param_4);
}

float FLT_flutter_local_smoothUnion(float d1, float d2, float k)
{
    if (k <= 0.0)
    {
        return min(d1, d2);
    }
    float e = max(k - abs(d1 - d2), 0.0);
    return min(d1, d2) - (((e * e) * 0.25) / k);
}

float FLT_flutter_local_sceneSDF(vec2 p, int numShapes, float shapeData[96], float blend)
{
    if (numShapes == 0)
    {
        return 1000000000.0;
    }
    int param = 0;
    vec2 param_1 = p;
    float param_2[96] = shapeData;
    float result = FLT_flutter_local_getShapeSDFFromArray(param, param_1, param_2);
    if (numShapes <= 4)
    {
        if (numShapes >= 2)
        {
            int param_3 = 1;
            vec2 param_4 = p;
            float param_5[96] = shapeData;
            float shapeSDF = FLT_flutter_local_getShapeSDFFromArray(param_3, param_4, param_5);
            float param_6 = result;
            float param_7 = shapeSDF;
            float param_8 = blend;
            result = FLT_flutter_local_smoothUnion(param_6, param_7, param_8);
        }
        if (numShapes >= 3)
        {
            int param_9 = 2;
            vec2 param_10 = p;
            float param_11[96] = shapeData;
            float shapeSDF_1 = FLT_flutter_local_getShapeSDFFromArray(param_9, param_10, param_11);
            float param_12 = result;
            float param_13 = shapeSDF_1;
            float param_14 = blend;
            result = FLT_flutter_local_smoothUnion(param_12, param_13, param_14);
        }
        if (numShapes >= 4)
        {
            int param_15 = 3;
            vec2 param_16 = p;
            float param_17[96] = shapeData;
            float shapeSDF_2 = FLT_flutter_local_getShapeSDFFromArray(param_15, param_16, param_17);
            float param_18 = result;
            float param_19 = shapeSDF_2;
            float param_20 = blend;
            result = FLT_flutter_local_smoothUnion(param_18, param_19, param_20);
        }
    }
    else
    {
        for (int i = 1; i < min(numShapes, 16); i++)
        {
            int param_21 = i;
            vec2 param_22 = p;
            float param_23[96] = shapeData;
            float shapeSDF_3 = FLT_flutter_local_getShapeSDFFromArray(param_21, param_22, param_23);
            float param_24 = result;
            float param_25 = shapeSDF_3;
            float param_26 = blend;
            result = FLT_flutter_local_smoothUnion(param_24, param_25, param_26);
        }
    }
    return result;
}

vec3 FLT_flutter_local_getNormal(float sd, float thickness)
{
    float dx = dFdx(sd);
    float dy = dFdy(sd);
    float n_cos = max(thickness + sd, 0.0) / thickness;
    float n_sin = sqrt(max(0.0, 1.0 - (n_cos * n_cos)));
    return normalize(vec3(dx * n_cos, dy * n_cos, n_sin));
}

float FLT_flutter_local_getHeight(float sd, float thickness)
{
    if ((sd >= 0.0) || (thickness <= 0.0))
    {
        return 0.0;
    }
    if (sd < (-thickness))
    {
        return thickness;
    }
    float x = thickness + sd;
    return sqrt(max(0.0, (thickness * thickness) - (x * x)));
}

vec4 FLT_flutter_local_calculateRefraction(vec2 screenUV, vec3 normal, float height, float thickness, float refractiveIndex, float chromaticAberration, vec2 uSize_1, shader backgroundTexture, float blurRadius, out vec2 refractionDisplacement)
{
    float baseHeight = thickness * 8.0;
    vec3 incident = vec3(0.0, 0.0, -1.0);
    float invRefractiveIndex = 1.0 / refractiveIndex;
    vec2 invUSize = vec2(1.0) / uSize_1;
    vec3 baseRefract = refract(incident, normal, invRefractiveIndex);
    float baseRefractLength = (height + baseHeight) / max(0.001000000047497451305389404296875, abs(baseRefract.z));
    vec2 baseDisplacement = baseRefract.xy * baseRefractLength;
    refractionDisplacement = baseDisplacement;
    if (chromaticAberration < 0.001000000047497451305389404296875)
    {
        vec2 refractedUV = screenUV + (baseDisplacement * invUSize);
        return backgroundTexture.eval(backgroundTexture_size * ( refractedUV));
    }
    float dispersionStrength = chromaticAberration * 0.5;
    vec2 redOffset = baseDisplacement * (1.0 + dispersionStrength);
    vec2 blueOffset = baseDisplacement * (1.0 - dispersionStrength);
    vec2 redUV = screenUV + (redOffset * invUSize);
    vec2 greenUV = screenUV + (baseDisplacement * invUSize);
    vec2 blueUV = screenUV + (blueOffset * invUSize);
    float red = backgroundTexture.eval(backgroundTexture_size * ( redUV)).x;
    vec4 greenSample = backgroundTexture.eval(backgroundTexture_size * ( greenUV));
    float blue = backgroundTexture.eval(backgroundTexture_size * ( blueUV)).z;
    return vec4(red, greenSample.y, blue, greenSample.w);
}

vec3 FLT_flutter_local_getHighlightColor(vec3 backgroundColor, float targetBrightness)
{
    float luminance = dot(backgroundColor, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
    float maxComponent = max(max(backgroundColor.x, backgroundColor.y), backgroundColor.z);
    float minComponent = min(min(backgroundColor.x, backgroundColor.y), backgroundColor.z);
    float _210;
    if (maxComponent > 0.0)
    {
        _210 = (maxComponent - minComponent) / maxComponent;
    }
    else
    {
        _210 = 0.0;
    }
    float saturation = _210;
    vec3 coloredHighlight = vec3(targetBrightness);
    if (luminance > 0.001000000047497451305389404296875)
    {
        vec3 normalizedBackground = backgroundColor / vec3(luminance);
        coloredHighlight = normalizedBackground * targetBrightness;
        float saturationBoost = 1.2999999523162841796875;
        vec3 gray = vec3(dot(coloredHighlight, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625)));
        coloredHighlight = mix(gray, coloredHighlight, vec3(saturationBoost));
        coloredHighlight = min(coloredHighlight, vec3(1.0));
    }
    float luminanceFactor = smoothstep(0.0, 0.60000002384185791015625, luminance);
    float saturationFactor = smoothstep(0.0, 0.4000000059604644775390625, saturation);
    float colorInfluence = luminanceFactor * saturationFactor;
    vec3 whiteHighlight = vec3(targetBrightness);
    return mix(whiteHighlight, coloredHighlight, vec3(colorInfluence));
}

vec3 FLT_flutter_local_calculateLighting(vec2 uv, vec3 normal, float sd, float thickness, float height, vec2 lightDirection, float lightIntensity, float ambientStrength, vec3 backgroundColor)
{
    float _307;
    if (thickness > 0.0)
    {
        _307 = height / thickness;
    }
    else
    {
        _307 = 0.0;
    }
    float normalizedHeight = _307;
    float shape = clamp((1.0 - normalizedHeight) * 1.11099994182586669921875, 0.0, 1.0);
    if (shape < 0.00999999977648258209228515625)
    {
        return vec3(0.0);
    }
    float thicknessFactor = clamp((thickness - 5.0) * 0.5, 0.0, 1.0);
    if (thicknessFactor < 0.00999999977648258209228515625)
    {
        return vec3(0.0);
    }
    float rimWidth = 1.5;
    float k = 0.88999998569488525390625;
    float x = sd / rimWidth;
    float rimFactor = 1.0 / (1.0 + ((k * x) * x));
    if ((rimFactor < 0.00999999977648258209228515625) || (lightIntensity < 0.00999999977648258209228515625))
    {
        return vec3(0.0);
    }
    vec2 normalXY = normal.xy;
    float mainLightInfluence = max(0.0, dot(normalXY, lightDirection));
    float oppositeLightInfluence = max(0.0, dot(normalXY, -lightDirection));
    float totalInfluence = mainLightInfluence + (oppositeLightInfluence * 0.800000011920928955078125);
    vec3 param = backgroundColor;
    float param_1 = 1.0;
    vec3 highlightColor = FLT_flutter_local_getHighlightColor(param, param_1);
    vec3 directionalRim = (((highlightColor * 0.699999988079071044921875) * (totalInfluence * totalInfluence)) * lightIntensity) * 2.0;
    vec3 ambientRim = (highlightColor * 0.4000000059604644775390625) * ambientStrength;
    vec3 totalRimLight = (directionalRim + ambientRim) * rimFactor;
    return (totalRimLight * thicknessFactor) * shape;
}

vec4 FLT_flutter_local_applyGlassColor(vec4 liquidColor, vec4 glassColor)
{
    vec4 finalColor = liquidColor;
    if (glassColor.w > 0.0)
    {
        float glassLuminance = dot(glassColor.xyz, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
        if (glassLuminance < 0.5)
        {
            vec3 darkened = liquidColor.xyz * (glassColor.xyz * 2.0);
            vec3 _565 = mix(liquidColor.xyz, darkened, vec3(glassColor.w));
            finalColor.x = _565.x;
            finalColor.y = _565.y;
            finalColor.z = _565.z;
        }
        else
        {
            vec3 invLiquid = vec3(1.0) - liquidColor.xyz;
            vec3 invGlass = vec3(1.0) - glassColor.xyz;
            vec3 screened = vec3(1.0) - (invLiquid * invGlass);
            vec3 _592 = mix(liquidColor.xyz, screened, vec3(glassColor.w));
            finalColor.x = _592.x;
            finalColor.y = _592.y;
            finalColor.z = _592.z;
        }
        finalColor.w = liquidColor.w;
    }
    return finalColor;
}

vec3 FLT_flutter_local_applySaturation(vec3 color, float saturation)
{
    float luminance = dot(color, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
    vec3 saturatedColor = mix(vec3(luminance), color, vec3(saturation));
    return clamp(saturatedColor, vec3(0.0), vec3(1.0));
}

vec4 FLT_flutter_local_renderLiquidGlass(vec2 screenUV, vec2 p, vec2 uSize_1, float sd, float thickness, float refractiveIndex, float chromaticAberration, vec4 glassColor, vec2 lightDirection, float lightIntensity, float ambientStrength, shader backgroundTexture, vec3 normal, float foregroundAlpha, float gaussianBlur, float saturation)
{
    float param = sd;
    float param_1 = thickness;
    float height = FLT_flutter_local_getHeight(param, param_1);
    vec2 param_2 = screenUV;
    vec3 param_3 = normal;
    float param_4 = height;
    float param_5 = thickness;
    float param_6 = refractiveIndex;
    float param_7 = chromaticAberration;
    vec2 param_8 = uSize_1;
    float param_9 = gaussianBlur;
    vec2 param_10;
    vec4 _630 = FLT_flutter_local_calculateRefraction(param_2, param_3, param_4, param_5, param_6, param_7, param_8, backgroundTexture, param_9, param_10);
    vec2 refractionDisplacement = param_10;
    vec4 refractColor = _630;
    vec3 backgroundColor = refractColor.xyz;
    vec2 param_11 = screenUV;
    vec3 param_12 = normal;
    float param_13 = sd;
    float param_14 = thickness;
    float param_15 = height;
    vec2 param_16 = lightDirection;
    float param_17 = lightIntensity;
    float param_18 = ambientStrength;
    vec3 param_19 = backgroundColor;
    vec3 lighting = FLT_flutter_local_calculateLighting(param_11, param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19);
    vec4 param_20 = refractColor;
    vec4 param_21 = glassColor;
    vec4 finalColor = FLT_flutter_local_applyGlassColor(param_20, param_21);
    vec4 _662 = finalColor;
    vec3 _664 = _662.xyz + lighting;
    finalColor.x = _664.x;
    finalColor.y = _664.y;
    finalColor.z = _664.z;
    vec3 param_22 = finalColor.xyz;
    float param_23 = saturation;
    vec3 _676 = FLT_flutter_local_applySaturation(param_22, param_23);
    finalColor.x = _676.x;
    finalColor.y = _676.y;
    finalColor.z = _676.z;
    return mix(vec4(0.0), finalColor, vec4(foregroundAlpha));
}

void FLT_main()
{
    uChromaticAberration = uOpticalProps.y;
    uLightAngle = uLightConfig.x;
    uLightIntensity = uLightConfig.y;
    uAmbientStrength = uLightConfig.z;
    uThickness = uOpticalProps.z;
    uRefractiveIndex = uOpticalProps.x;
    uBlend = uOpticalProps.w;
    uSaturation = uLightConfig.w;
    vec2 fragCoord = FLT_flutter_local_FlutterFragCoord();
    vec2 screenUV_1 = vec2(fragCoord.x / uSize.x, fragCoord.y / uSize.y);
    vec2 param_24 = fragCoord;
    int param_25 = int(uNumShapes);
    float param_26[96] = uShapeData;
    float param_27 = uBlend;
    float sd_1 = FLT_flutter_local_sceneSDF(param_24, param_25, param_26, param_27);
    float foregroundAlpha_1 = 1.0 - smoothstep(-2.0, 0.0, sd_1);
    if (foregroundAlpha_1 < 0.00999999977648258209228515625)
    {
        fragColor = vec4(0.0);
        return;
    }
    float param_28 = sd_1;
    float param_29 = uThickness;
    vec3 normal_1 = FLT_flutter_local_getNormal(param_28, param_29);
    vec2 param_30 = screenUV_1;
    vec2 param_31 = fragCoord;
    vec2 param_32 = uSize;
    float param_33 = sd_1;
    float param_34 = uThickness;
    float param_35 = uRefractiveIndex;
    float param_36 = uChromaticAberration;
    vec4 param_37 = uGlassColor;
    vec2 param_38 = uLightDirection;
    float param_39 = uLightIntensity;
    float param_40 = uAmbientStrength;
    vec3 param_41 = normal_1;
    float param_42 = foregroundAlpha_1;
    float param_43 = 0.0;
    float param_44 = uSaturation;
    fragColor = FLT_flutter_local_renderLiquidGlass(param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37, param_38, param_39, param_40, uBlurredTexture, param_41, param_42, param_43, param_44);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
            0        \       0           (    ,                                `       
   uShapeData  $                                
   uNumShapes  (                                       uLightDirection (                                       uLightConfig   ,              (                                    
   uOpticalProps  (              $                                   uGlassColor                                         uBlurredTexture    $                                               uSize   !   liquid_glass_filter_fragment_main   