   IPLR       1        0  -     -  #include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

struct liquid_glass_arbitrary_fragment_main_out
{
    float4 fragColor [[color(0)]];
};

struct liquid_glass_arbitrary_fragment_main_in
{
    float2 _fragCoord [[user(locn0)]];
};

fragment liquid_glass_arbitrary_fragment_main_out liquid_glass_arbitrary_fragment_main(liquid_glass_arbitrary_fragment_main_in in [[stage_in]], constant float2& uSize [[buffer(0)]], constant float2& uForegroundSize [[buffer(1)]], constant float4& uGlassColor [[buffer(2)]], constant float4& uOpticalProps [[buffer(3)]], constant float4& uLightConfig [[buffer(4)]], constant float2& uTransformData [[buffer(5)]], constant float2& uLightDirection [[buffer(6)]], constant float4x4& uTransform [[buffer(7)]], texture2d<float> uBackgroundTexture [[texture(0)]], texture2d<float> uForegroundTexture [[texture(1)]], texture2d<float> uForegroundBlurredTexture [[texture(2)]], sampler uBackgroundTextureSmplr [[sampler(0)]], sampler uForegroundTextureSmplr [[sampler(1)]], sampler uForegroundBlurredTextureSmplr [[sampler(2)]])
{
    liquid_glass_arbitrary_fragment_main_out out = {};
    do
    {
        float2 _873 = float2(in._fragCoord.x / uSize.x, in._fragCoord.y / uSize.y);
        float4 _887 = uTransform * float4(in._fragCoord - uTransformData, 0.0, 1.0);
        float _1041 = _887.y / uForegroundSize.y;
        float _900 = _887.x / uForegroundSize.x;
        float2 _902 = float2(_900, _1041);
        bool _905 = _900 < 0.0;
        bool _912;
        if (!_905)
        {
            _912 = _900 > 1.0;
        }
        else
        {
            _912 = _905;
        }
        bool _919;
        if (!_912)
        {
            _919 = _1041 < 0.0;
        }
        else
        {
            _919 = _912;
        }
        bool _926;
        if (!_919)
        {
            _926 = _1041 > 1.0;
        }
        else
        {
            _926 = _919;
        }
        if (_926)
        {
            out.fragColor = uBackgroundTexture.sample(uBackgroundTextureSmplr, _873);
            break;
        }
        float4 _939 = uForegroundTexture.sample(uForegroundTextureSmplr, _902);
        float _941 = _939.w;
        if (_941 < 0.001000000047497451305389404296875)
        {
            out.fragColor = uBackgroundTexture.sample(uBackgroundTextureSmplr, _873);
            break;
        }
        float4 _952 = uForegroundBlurredTexture.sample(uForegroundBlurredTextureSmplr, _902);
        float _1050 = (-smoothstep(0.0, 1.0, _952.w)) * uOpticalProps.z;
        float3 _1790;
        do
        {
            float2 _1076 = _887.xy / uForegroundSize;
            if (uForegroundTexture.sample(uForegroundTextureSmplr, _1076).w < 0.00999999977648258209228515625)
            {
                _1790 = float3(0.0, 0.0, 1.0);
                break;
            }
            float2 _1138 = float2(2.0) / uForegroundSize;
            float _1772;
            float2 _1773;
            _1773 = float2(0.0);
            _1772 = 0.0;
            float2 _1780;
            float _1784;
            for (int _1771 = -10; _1771 <= 10; _1773 = _1780, _1772 = _1784, _1771++)
            {
                _1784 = _1772;
                _1780 = _1773;
                float2 _1804;
                float _1806;
                for (int _1775 = -10; _1775 <= 10; _1784 = _1806, _1780 = _1804, _1775++)
                {
                    float2 _1163 = _1076 + (float2(float(_1775), float(_1771)) * _1138);
                    float _1165 = _1163.x;
                    bool _1166 = _1165 >= 0.0;
                    bool _1172;
                    if (_1166)
                    {
                        _1172 = _1165 <= 1.0;
                    }
                    else
                    {
                        _1172 = _1166;
                    }
                    bool _1178;
                    if (_1172)
                    {
                        _1178 = _1163.y >= 0.0;
                    }
                    else
                    {
                        _1178 = _1172;
                    }
                    bool _1184;
                    if (_1178)
                    {
                        _1184 = _1163.y <= 1.0;
                    }
                    else
                    {
                        _1184 = _1178;
                    }
                    if (_1184)
                    {
                        float4 _1188 = uForegroundTexture.sample(uForegroundTextureSmplr, _1163);
                        float _1189 = _1188.w;
                        float2 _1805;
                        float _1807;
                        if (_1189 > 0.100000001490116119384765625)
                        {
                            _1807 = _1784 + _1189;
                            _1805 = _1780 + (_1163 * _1189);
                        }
                        else
                        {
                            _1807 = _1784;
                            _1805 = _1780;
                        }
                        _1806 = _1807;
                        _1804 = _1805;
                    }
                    else
                    {
                        _1806 = _1784;
                        _1804 = _1780;
                    }
                }
            }
            float2 _1774;
            if (_1772 > 0.0)
            {
                _1774 = _1773 / float2(_1772);
            }
            else
            {
                _1774 = _1076;
            }
            float2 _1088 = _1076 - _1774;
            if (length(_1088) < 0.001000000047497451305389404296875)
            {
                _1790 = float3(0.0, 0.0, 1.0);
                break;
            }
            float _1108 = powr(smoothstep(0.0, 1.0, uForegroundBlurredTexture.sample(uForegroundBlurredTextureSmplr, _1076).w), 0.20000000298023223876953125);
            _1790 = fast::normalize(float3(fast::normalize(_1088) * sqrt(fast::max(0.0, 1.0 - (_1108 * _1108))), _1108));
            break;
        } while(false);
        float _1791;
        do
        {
            if ((_1050 >= 0.0) || (uOpticalProps.z <= 0.0))
            {
                _1791 = 0.0;
                break;
            }
            if (_1050 < (-uOpticalProps.z))
            {
                _1791 = uOpticalProps.z;
                break;
            }
            float _1328 = uOpticalProps.z + _1050;
            _1791 = sqrt(fast::max(0.0, (uOpticalProps.z * uOpticalProps.z) - (_1328 * _1328)));
            break;
        } while(false);
        float4 _1792;
        do
        {
            float2 _1368 = float2(1.0) / uSize;
            float3 _1372 = refract(float3(0.0, 0.0, -1.0), _1790, 1.0 / uOpticalProps.x);
            float2 _1384 = _1372.xy * ((_1791 + (uOpticalProps.z * 8.0)) / fast::max(0.001000000047497451305389404296875, abs(_1372.z)));
            if (uOpticalProps.y < 0.001000000047497451305389404296875)
            {
                _1792 = uBackgroundTexture.sample(uBackgroundTextureSmplr, (_873 + (_1384 * _1368)));
                break;
            }
            float _1399 = uOpticalProps.y * 0.5;
            float4 _1429 = uBackgroundTexture.sample(uBackgroundTextureSmplr, (_873 + (_1384 * _1368)));
            _1792 = float4(uBackgroundTexture.sample(uBackgroundTextureSmplr, (_873 + ((_1384 * (1.0 + _1399)) * _1368))).x, _1429.y, uBackgroundTexture.sample(uBackgroundTextureSmplr, (_873 + ((_1384 * (1.0 - _1399)) * _1368))).z, _1429.w);
            break;
        } while(false);
        float3 _1796;
        do
        {
            float _1793;
            if (uOpticalProps.z > 0.0)
            {
                _1793 = _1791 / uOpticalProps.z;
            }
            else
            {
                _1793 = 0.0;
            }
            float _1478 = fast::clamp((1.0 - _1793) * 1.11099994182586669921875, 0.0, 1.0);
            if (_1478 < 0.00999999977648258209228515625)
            {
                _1796 = float3(0.0);
                break;
            }
            float _1486 = fast::clamp((uOpticalProps.z - 5.0) * 0.5, 0.0, 1.0);
            if (_1486 < 0.00999999977648258209228515625)
            {
                _1796 = float3(0.0);
                break;
            }
            float _1500 = 1.0 / (1.0 + ((_1050 * 0.59333336353302001953125) * (_1050 * 0.666666686534881591796875)));
            if ((_1500 < 0.00999999977648258209228515625) || (uLightConfig.y < 0.00999999977648258209228515625))
            {
                _1796 = float3(0.0);
                break;
            }
            float _1522 = fast::max(0.0, dot(_1790.xy, uLightDirection)) + (fast::max(0.0, dot(_1790.xy, -uLightDirection)) * 0.800000011920928955078125);
            float _1566 = dot(_1792.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
            float _1574 = fast::max(fast::max(_1792.x, _1792.y), _1792.z);
            float _1794;
            if (_1574 > 0.0)
            {
                _1794 = (_1574 - fast::min(fast::min(_1792.x, _1792.y), _1792.z)) / _1574;
            }
            else
            {
                _1794 = 0.0;
            }
            float3 _1795;
            if (_1566 > 0.001000000047497451305389404296875)
            {
                float3 _1605 = (_1792.xyz / float3(_1566)) * 1.0;
                _1795 = fast::min(mix(float3(dot(_1605, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625))), _1605, float3(1.2999999523162841796875)), float3(1.0));
            }
            else
            {
                _1795 = float3(1.0);
            }
            float3 _1630 = mix(float3(1.0), _1795, float3(smoothstep(0.0, 0.60000002384185791015625, _1566) * smoothstep(0.0, 0.4000000059604644775390625, _1794)));
            _1796 = (((((((_1630 * 0.699999988079071044921875) * (_1522 * _1522)) * uLightConfig.y) * 2.0) + ((_1630 * 0.4000000059604644775390625) * uLightConfig.z)) * _1500) * _1486) * _1478;
            break;
        } while(false);
        float4 _1798;
        if (uGlassColor.w > 0.0)
        {
            float4 _1797;
            if (dot(uGlassColor.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625)) < 0.5)
            {
                float3 _1662 = mix(_1792.xyz, _1792.xyz * (uGlassColor.xyz * 2.0), float3(uGlassColor.w));
                float4 _1744 = _1792;
                _1744.x = _1662.x;
                _1744.y = _1662.y;
                _1744.z = _1662.z;
                _1797 = _1744;
            }
            else
            {
                float3 _1686 = mix(_1792.xyz, float3(1.0) - ((float3(1.0) - _1792.xyz) * (float3(1.0) - uGlassColor.xyz)), float3(uGlassColor.w));
                float4 _1751 = _1792;
                _1751.x = _1686.x;
                _1751.y = _1686.y;
                _1751.z = _1686.z;
                _1797 = _1751;
            }
            float4 _1758 = _1797;
            _1758.w = _1792.w;
            _1798 = _1758;
        }
        else
        {
            _1798 = _1792;
        }
        float3 _1285 = _1798.xyz + _1796;
        float4 _1760 = _1798;
        _1760.x = _1285.x;
        _1760.y = _1285.y;
        _1760.z = _1285.z;
        float3 _1714 = fast::clamp(mix(float3(dot(_1760.xyz, float3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625))), _1760.xyz, float3(uLightConfig.w)), float3(0.0), float3(1.0));
        float4 _1766 = _1760;
        _1766.x = _1714.x;
        _1766.y = _1714.y;
        _1766.z = _1714.z;
        out.fragColor = mix(float4(0.0), _1766, float4(_941));
        break;
    } while(false);
    return out;
}

      l  ,      P          @      *$                                
   uTransform  B(                                       uLightDirection (                                       uTransformData  ¾(                                       uLightConfig    (                                    
   uOpticalProps   B(                                       uGlassColor ҿ$                                  uForegroundBlurredTexture  $                                            uForegroundTexture  2$                                   uForegroundSize                            uBackgroundTexture     $                                               uSize   $   liquid_glass_arbitrary_fragment_main                ?  <     <  // This SkSL shader is autogenerated by spirv-cross.

float4 flutter_FragCoord;

uniform vec2 uSize;
uniform vec2 uForegroundSize;
uniform vec4 uGlassColor;
uniform vec4 uOpticalProps;
uniform vec4 uLightConfig;
uniform vec2 uTransformData;
uniform vec2 uLightDirection;
uniform mat4 uTransform;
uniform shader uBackgroundTexture;
uniform half2 uBackgroundTexture_size;
uniform shader uForegroundTexture;
uniform half2 uForegroundTexture_size;
uniform shader uForegroundBlurredTexture;
uniform half2 uForegroundBlurredTexture_size;

vec4 fragColor;

float uChromaticAberration;
float uLightAngle;
float uLightIntensity;
float uAmbientStrength;
float uThickness;
float uRefractiveIndex;
vec2 uOffset;
float uSaturation;
float uGaussianBlur;

vec2 FLT_flutter_local_FlutterFragCoord()
{
    return flutter_FragCoord.xy;
}

float FLT_flutter_local_computeY(float coordY, vec2 size)
{
    return coordY / size.y;
}

float FLT_flutter_local_approximateSDF(float blurredAlpha, float thickness)
{
    float normalizedDistance = smoothstep(0.0, 1.0, blurredAlpha);
    return (-normalizedDistance) * thickness;
}

vec2 FLT_flutter_local_findShapeCenter(vec2 currentUV)
{
    vec2 texelSize = vec2(2.0) / uForegroundSize;
    vec2 centerSum = vec2(0.0);
    float totalAlpha = 0.0;
    int sampleRadius = 10;
    int _692 = -sampleRadius;
    for (int y = _692; y <= sampleRadius; y++)
    {
        int _703 = -sampleRadius;
        for (int x = _703; x <= sampleRadius; x++)
        {
            vec2 sampleUV = currentUV + (vec2(float(x), float(y)) * texelSize);
            bool _724 = sampleUV.x >= 0.0;
            bool _730;
            if (_724)
            {
                _730 = sampleUV.x <= 1.0;
            }
            else
            {
                _730 = _724;
            }
            bool _736;
            if (_730)
            {
                _736 = sampleUV.y >= 0.0;
            }
            else
            {
                _736 = _730;
            }
            bool _742;
            if (_736)
            {
                _742 = sampleUV.y <= 1.0;
            }
            else
            {
                _742 = _736;
            }
            if (_742)
            {
                float alpha = uForegroundTexture.eval(uForegroundTexture_size * ( sampleUV)).w;
                if (alpha > 0.100000001490116119384765625)
                {
                    centerSum += (sampleUV * alpha);
                    totalAlpha += alpha;
                }
            }
        }
    }
    vec2 _771;
    if (totalAlpha > 0.0)
    {
        _771 = centerSum / vec2(totalAlpha);
    }
    else
    {
        _771 = currentUV;
    }
    return _771;
}

vec3 FLT_flutter_local_getReconstructedNormal(vec2 p, float thickness)
{
    vec2 uv = p / uForegroundSize;
    if (uForegroundTexture.eval(uForegroundTexture_size * ( uv)).w < 0.00999999977648258209228515625)
    {
        return vec3(0.0, 0.0, 1.0);
    }
    vec2 param = uv;
    vec2 shapeCenter = FLT_flutter_local_findShapeCenter(param);
    vec2 centerToPoint = uv - shapeCenter;
    if (length(centerToPoint) < 0.001000000047497451305389404296875)
    {
        return vec3(0.0, 0.0, 1.0);
    }
    vec2 outwardDirection = normalize(centerToPoint);
    float blurredAlpha = uForegroundBlurredTexture.eval(uForegroundBlurredTexture_size * ( uv)).w;
    float sharpAlpha = uForegroundTexture.eval(uForegroundTexture_size * ( uv)).w;
    float edgeDistance = smoothstep(0.0, 1.0, blurredAlpha);
    float normalExponent = 0.20000000298023223876953125;
    float normalZ = pow(edgeDistance, normalExponent);
    float xyScale = sqrt(max(0.0, 1.0 - (normalZ * normalZ)));
    return normalize(vec3(outwardDirection * xyScale, normalZ));
}

vec3 FLT_flutter_local_getNormal(vec2 p, float thickness)
{
    vec2 param = p;
    float param_1 = thickness;
    return FLT_flutter_local_getReconstructedNormal(param, param_1);
}

float FLT_flutter_local_getHeight(float sd, float thickness)
{
    if ((sd >= 0.0) || (thickness <= 0.0))
    {
        return 0.0;
    }
    if (sd < (-thickness))
    {
        return thickness;
    }
    float x = thickness + sd;
    return sqrt(max(0.0, (thickness * thickness) - (x * x)));
}

vec4 FLT_flutter_local_calculateRefraction(vec2 screenUV, vec3 normal, float height, float thickness, float refractiveIndex, float chromaticAberration, vec2 uSize_1, shader backgroundTexture, float blurRadius, out vec2 refractionDisplacement)
{
    float baseHeight = thickness * 8.0;
    vec3 incident = vec3(0.0, 0.0, -1.0);
    float invRefractiveIndex = 1.0 / refractiveIndex;
    vec2 invUSize = vec2(1.0) / uSize_1;
    vec3 baseRefract = refract(incident, normal, invRefractiveIndex);
    float baseRefractLength = (height + baseHeight) / max(0.001000000047497451305389404296875, abs(baseRefract.z));
    vec2 baseDisplacement = baseRefract.xy * baseRefractLength;
    refractionDisplacement = baseDisplacement;
    if (chromaticAberration < 0.001000000047497451305389404296875)
    {
        vec2 refractedUV = screenUV + (baseDisplacement * invUSize);
        return backgroundTexture.eval(backgroundTexture_size * ( refractedUV));
    }
    float dispersionStrength = chromaticAberration * 0.5;
    vec2 redOffset = baseDisplacement * (1.0 + dispersionStrength);
    vec2 blueOffset = baseDisplacement * (1.0 - dispersionStrength);
    vec2 redUV = screenUV + (redOffset * invUSize);
    vec2 greenUV = screenUV + (baseDisplacement * invUSize);
    vec2 blueUV = screenUV + (blueOffset * invUSize);
    float red = backgroundTexture.eval(backgroundTexture_size * ( redUV)).x;
    vec4 greenSample = backgroundTexture.eval(backgroundTexture_size * ( greenUV));
    float blue = backgroundTexture.eval(backgroundTexture_size * ( blueUV)).z;
    return vec4(red, greenSample.y, blue, greenSample.w);
}

vec3 FLT_flutter_local_getHighlightColor(vec3 backgroundColor, float targetBrightness)
{
    float luminance = dot(backgroundColor, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
    float maxComponent = max(max(backgroundColor.x, backgroundColor.y), backgroundColor.z);
    float minComponent = min(min(backgroundColor.x, backgroundColor.y), backgroundColor.z);
    float _189;
    if (maxComponent > 0.0)
    {
        _189 = (maxComponent - minComponent) / maxComponent;
    }
    else
    {
        _189 = 0.0;
    }
    float saturation = _189;
    vec3 coloredHighlight = vec3(targetBrightness);
    if (luminance > 0.001000000047497451305389404296875)
    {
        vec3 normalizedBackground = backgroundColor / vec3(luminance);
        coloredHighlight = normalizedBackground * targetBrightness;
        float saturationBoost = 1.2999999523162841796875;
        vec3 gray = vec3(dot(coloredHighlight, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625)));
        coloredHighlight = mix(gray, coloredHighlight, vec3(saturationBoost));
        coloredHighlight = min(coloredHighlight, vec3(1.0));
    }
    float luminanceFactor = smoothstep(0.0, 0.60000002384185791015625, luminance);
    float saturationFactor = smoothstep(0.0, 0.4000000059604644775390625, saturation);
    float colorInfluence = luminanceFactor * saturationFactor;
    vec3 whiteHighlight = vec3(targetBrightness);
    return mix(whiteHighlight, coloredHighlight, vec3(colorInfluence));
}

vec3 FLT_flutter_local_calculateLighting(vec2 uv, vec3 normal, float sd, float thickness, float height, vec2 lightDirection, float lightIntensity, float ambientStrength, vec3 backgroundColor)
{
    float _286;
    if (thickness > 0.0)
    {
        _286 = height / thickness;
    }
    else
    {
        _286 = 0.0;
    }
    float normalizedHeight = _286;
    float shape = clamp((1.0 - normalizedHeight) * 1.11099994182586669921875, 0.0, 1.0);
    if (shape < 0.00999999977648258209228515625)
    {
        return vec3(0.0);
    }
    float thicknessFactor = clamp((thickness - 5.0) * 0.5, 0.0, 1.0);
    if (thicknessFactor < 0.00999999977648258209228515625)
    {
        return vec3(0.0);
    }
    float rimWidth = 1.5;
    float k = 0.88999998569488525390625;
    float x = sd / rimWidth;
    float rimFactor = 1.0 / (1.0 + ((k * x) * x));
    if ((rimFactor < 0.00999999977648258209228515625) || (lightIntensity < 0.00999999977648258209228515625))
    {
        return vec3(0.0);
    }
    vec2 normalXY = normal.xy;
    float mainLightInfluence = max(0.0, dot(normalXY, lightDirection));
    float oppositeLightInfluence = max(0.0, dot(normalXY, -lightDirection));
    float totalInfluence = mainLightInfluence + (oppositeLightInfluence * 0.800000011920928955078125);
    vec3 param = backgroundColor;
    float param_1 = 1.0;
    vec3 highlightColor = FLT_flutter_local_getHighlightColor(param, param_1);
    vec3 directionalRim = (((highlightColor * 0.699999988079071044921875) * (totalInfluence * totalInfluence)) * lightIntensity) * 2.0;
    vec3 ambientRim = (highlightColor * 0.4000000059604644775390625) * ambientStrength;
    vec3 totalRimLight = (directionalRim + ambientRim) * rimFactor;
    return (totalRimLight * thicknessFactor) * shape;
}

vec4 FLT_flutter_local_applyGlassColor(vec4 liquidColor, vec4 glassColor)
{
    vec4 finalColor = liquidColor;
    if (glassColor.w > 0.0)
    {
        float glassLuminance = dot(glassColor.xyz, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
        if (glassLuminance < 0.5)
        {
            vec3 darkened = liquidColor.xyz * (glassColor.xyz * 2.0);
            vec3 _544 = mix(liquidColor.xyz, darkened, vec3(glassColor.w));
            finalColor.x = _544.x;
            finalColor.y = _544.y;
            finalColor.z = _544.z;
        }
        else
        {
            vec3 invLiquid = vec3(1.0) - liquidColor.xyz;
            vec3 invGlass = vec3(1.0) - glassColor.xyz;
            vec3 screened = vec3(1.0) - (invLiquid * invGlass);
            vec3 _571 = mix(liquidColor.xyz, screened, vec3(glassColor.w));
            finalColor.x = _571.x;
            finalColor.y = _571.y;
            finalColor.z = _571.z;
        }
        finalColor.w = liquidColor.w;
    }
    return finalColor;
}

vec3 FLT_flutter_local_applySaturation(vec3 color, float saturation)
{
    float luminance = dot(color, vec3(0.2989999949932098388671875, 0.58700001239776611328125, 0.114000000059604644775390625));
    vec3 saturatedColor = mix(vec3(luminance), color, vec3(saturation));
    return clamp(saturatedColor, vec3(0.0), vec3(1.0));
}

vec4 FLT_flutter_local_renderLiquidGlass(vec2 screenUV, vec2 p, vec2 uSize_1, float sd, float thickness, float refractiveIndex, float chromaticAberration, vec4 glassColor, vec2 lightDirection, float lightIntensity, float ambientStrength, shader backgroundTexture, vec3 normal, float foregroundAlpha, float gaussianBlur, float saturation)
{
    float param = sd;
    float param_1 = thickness;
    float height = FLT_flutter_local_getHeight(param, param_1);
    vec2 param_2 = screenUV;
    vec3 param_3 = normal;
    float param_4 = height;
    float param_5 = thickness;
    float param_6 = refractiveIndex;
    float param_7 = chromaticAberration;
    vec2 param_8 = uSize_1;
    float param_9 = gaussianBlur;
    vec2 param_10;
    vec4 _609 = FLT_flutter_local_calculateRefraction(param_2, param_3, param_4, param_5, param_6, param_7, param_8, backgroundTexture, param_9, param_10);
    vec2 refractionDisplacement = param_10;
    vec4 refractColor = _609;
    vec3 backgroundColor = refractColor.xyz;
    vec2 param_11 = screenUV;
    vec3 param_12 = normal;
    float param_13 = sd;
    float param_14 = thickness;
    float param_15 = height;
    vec2 param_16 = lightDirection;
    float param_17 = lightIntensity;
    float param_18 = ambientStrength;
    vec3 param_19 = backgroundColor;
    vec3 lighting = FLT_flutter_local_calculateLighting(param_11, param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19);
    vec4 param_20 = refractColor;
    vec4 param_21 = glassColor;
    vec4 finalColor = FLT_flutter_local_applyGlassColor(param_20, param_21);
    vec4 _641 = finalColor;
    vec3 _643 = _641.xyz + lighting;
    finalColor.x = _643.x;
    finalColor.y = _643.y;
    finalColor.z = _643.z;
    vec3 param_22 = finalColor.xyz;
    float param_23 = saturation;
    vec3 _655 = FLT_flutter_local_applySaturation(param_22, param_23);
    finalColor.x = _655.x;
    finalColor.y = _655.y;
    finalColor.z = _655.z;
    return mix(vec4(0.0), finalColor, vec4(foregroundAlpha));
}

void FLT_main()
{
    uChromaticAberration = uOpticalProps.y;
    uLightAngle = uLightConfig.x;
    uLightIntensity = uLightConfig.y;
    uAmbientStrength = uLightConfig.z;
    uThickness = uOpticalProps.z;
    uRefractiveIndex = uOpticalProps.x;
    uOffset = uTransformData;
    uSaturation = uLightConfig.w;
    uGaussianBlur = uOpticalProps.w;
    vec2 fragCoord = FLT_flutter_local_FlutterFragCoord();
    float param_24 = fragCoord.y;
    vec2 param_25 = uSize;
    float screenY = FLT_flutter_local_computeY(param_24, param_25);
    vec2 screenUV_1 = vec2(fragCoord.x / uSize.x, screenY);
    vec2 layerLocalCoord = fragCoord - uOffset;
    vec4 transformedCoord = uTransform * vec4(layerLocalCoord, 0.0, 1.0);
    float param_26 = transformedCoord.y;
    vec2 param_27 = uForegroundSize;
    float layerY = FLT_flutter_local_computeY(param_26, param_27);
    vec2 layerUV = vec2(transformedCoord.x / uForegroundSize.x, layerY);
    bool _906 = layerUV.x < 0.0;
    bool _913;
    if (!_906)
    {
        _913 = layerUV.x > 1.0;
    }
    else
    {
        _913 = _906;
    }
    bool _920;
    if (!_913)
    {
        _920 = layerUV.y < 0.0;
    }
    else
    {
        _920 = _913;
    }
    bool _927;
    if (!_920)
    {
        _927 = layerUV.y > 1.0;
    }
    else
    {
        _927 = _920;
    }
    if (_927)
    {
        fragColor = uBackgroundTexture.eval(uBackgroundTexture_size * ( screenUV_1));
        return;
    }
    vec4 foregroundColor = uForegroundTexture.eval(uForegroundTexture_size * ( layerUV));
    if (foregroundColor.w < 0.001000000047497451305389404296875)
    {
        fragColor = uBackgroundTexture.eval(uBackgroundTexture_size * ( screenUV_1));
        return;
    }
    vec4 blurred = uForegroundBlurredTexture.eval(uForegroundBlurredTexture_size * ( layerUV));
    float param_28 = blurred.w;
    float param_29 = uThickness;
    float sd_1 = FLT_flutter_local_approximateSDF(param_28, param_29);
    vec2 param_30 = transformedCoord.xy;
    float param_31 = uThickness;
    vec3 normal_1 = FLT_flutter_local_getNormal(param_30, param_31);
    vec2 param_32 = screenUV_1;
    vec2 param_33 = fragCoord;
    vec2 param_34 = uSize;
    float param_35 = sd_1;
    float param_36 = uThickness;
    float param_37 = uRefractiveIndex;
    float param_38 = uChromaticAberration;
    vec4 param_39 = uGlassColor;
    vec2 param_40 = uLightDirection;
    float param_41 = uLightIntensity;
    float param_42 = uAmbientStrength;
    vec3 param_43 = normal_1;
    float param_44 = foregroundColor.w;
    float param_45 = uGaussianBlur;
    float param_46 = uSaturation;
    fragColor = FLT_flutter_local_renderLiquidGlass(param_32, param_33, param_34, param_35, param_36, param_37, param_38, param_39, param_40, param_41, param_42, uBackgroundTexture, param_43, param_44, param_45, param_46);
}

half4 main(float2 iFragCoord)
{
      flutter_FragCoord = float4(iFragCoord, 0, 0);
      FLT_main();
      return fragColor;
}
        X       d           T         (              $                                
   uTransform  *(                                       uLightDirection j(                                       uTransformData  (                                       uLightConfig    (                                    
   uOpticalProps   *(                                       uGlassColor $                                  uForegroundBlurredTexture  (             $                                  uForegroundTexture     ,              (                                       uForegroundSize                                              uBackgroundTexture                                                uSize   $   liquid_glass_arbitrary_fragment_main    